﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class FruitView : MonoBehaviour
{
    public GlassView m_glassView;
    public Transform m_fruitParent;
    private List<FruitItemView> m_selectLst = new List<FruitItemView>();//选中的水果
    private int m_lineIndex = 0;//线段计数
    private FruitItemView m_curSelectItem;//当前选中的
    private FruitItemView m_lastSelectItem;//上次选中的
    private bool m_bIsTouchUp = true;//是否松手
    private List<GameObject> m_lineLst = new List<GameObject>();
    private int m_SelectNum = 0;//选中数量
    private List<GameObject> m_fruitBombEffect = new List<GameObject>();//爆汁特效
    private List<GameObject> m_fruitDropEffect = new List<GameObject>();//流体特效
    void Start()
    {
        GameServices.inputService.pad.onTouchUp += OnTouchUp;
        if (BattleCtrl.instance.levelManager.CurLevelIndex == LevelEnum.levelOneIndex)
        {
            GlobalConfig.LoadFirstLevelDefaultFruit(m_fruitParent);
        }
        else if (BattleCtrl.instance.levelManager.CurLevelIndex == LevelEnum.levelTwoIndex)
        {
            GlobalConfig.LoadSecondLevelDefaultFruit(m_fruitParent);
        }
    }
    // 抬起回调
    void OnTouchUp()
    {
        for (int i = 0; i < m_selectLst.Count; i++)
        {
            HighlightableObject varHO = m_selectLst[i].GetComponent<HighlightableObject>();
            if (varHO)
            {
                varHO.FlashingOff();
            }
            m_selectLst[i].SetFrag();
            //播放爆汁特效
            GameObject varEffectObj = null;
            int varRand = Random.Range(0, 2);
            if (m_selectLst[i].type == FruitType.Strawberry)
            {
                if (varRand == 0)
                {
                    varEffectObj = PoolManager.Instance.GetObjectFromPool(CacheManager.Instance.StarwberryEffect1);
                }
                else
                {
                    varEffectObj = PoolManager.Instance.GetObjectFromPool(CacheManager.Instance.StarwberryEffect2);
                }
            }
            else if (m_selectLst[i].type == FruitType.Lemon)
            {
                if (varRand == 0)
                {
                    varEffectObj = PoolManager.Instance.GetObjectFromPool(CacheManager.Instance.LemonEffect1);
                }
                else
                {
                    varEffectObj = PoolManager.Instance.GetObjectFromPool(CacheManager.Instance.LemonEffect2);
                }
            }
            else if(m_selectLst[i].type == FruitType.Orange)
            {
                if (varRand == 0)
                {
                    varEffectObj = PoolManager.Instance.GetObjectFromPool(CacheManager.Instance.OrangeEffect1);
                }
                else
                {
                    varEffectObj = PoolManager.Instance.GetObjectFromPool(CacheManager.Instance.OrangeEffect2);
                }
            }
            varEffectObj.transform.position = m_selectLst[i].transform.position;
            m_fruitBombEffect.Add(varEffectObj);
        }
        m_SelectNum = m_selectLst.Count;
        Invoke("DelayClear", 0.5f);
        Invoke("DelayClearEffect", 1.0f);
        m_bIsTouchUp = true;
        m_lastSelectItem = null;
        for(int i = 0;i< m_lineLst.Count;i++)
        {
            PoolManager.Instance.ReturnObjectToPool(m_lineLst[i]);
        }
        m_lineLst.Clear();
    }
    //延迟删除特效
    void DelayClearEffect()
    {
        for (int i = 0; i < m_fruitBombEffect.Count; i++)
        {
            PoolManager.Instance.ReturnObjectToPool(m_fruitBombEffect[i]);
        }
        m_fruitBombEffect.Clear();
    }
    //延迟删除流体特效
    void DelayClearDropEffect()
    {
        for (int i = 0; i < m_fruitDropEffect.Count; i++)
        {
            PoolManager.Instance.ReturnObjectToPool(m_fruitDropEffect[i]);
        }
        m_fruitDropEffect.Clear();
    }
    //延迟删除
    void DelayClear()
    {
        int varStrawberryNum = 0;
        int varLemonNum = 0;
        int varOrangeNum = 0;
        for (int i = 0; i < m_selectLst.Count; i++)
        {
            if (m_selectLst[i].type == FruitType.Strawberry)
            {
                varStrawberryNum++;
            }
            else if(m_selectLst[i].type == FruitType.Lemon)
            {
                varLemonNum++;
            }
            else if(m_selectLst[i].type == FruitType.Orange)
            {
                varOrangeNum++;
            }
            PoolManager.Instance.ReturnObjectToPool(m_selectLst[i].gameObject);
            m_selectLst[i].ResetFragState();
        }
        m_glassView.SetFruitNum(varStrawberryNum, varLemonNum, varOrangeNum);
        m_selectLst.Clear();

        //流体特效
        if (varStrawberryNum > 0)
        {
            GameObject varEffect1 = PoolManager.Instance.GetObjectFromPool(CacheManager.Instance.StarwberryDropEffect);
            varEffect1.transform.position = m_glassView.effectPos;
            m_fruitDropEffect.Add(varEffect1);
        }
        if(varLemonNum > 0)
        {
            GameObject varEffect2 = PoolManager.Instance.GetObjectFromPool(CacheManager.Instance.LemonDropEffect);
            varEffect2.transform.position = m_glassView.effectPos;
            m_fruitDropEffect.Add(varEffect2);
        }
        if (varOrangeNum > 0)
        {
            GameObject varEffect3 = PoolManager.Instance.GetObjectFromPool(CacheManager.Instance.OrangeDropEffect);
            varEffect3.transform.position = m_glassView.effectPos;
            m_fruitDropEffect.Add(varEffect3);
        }
        Invoke("DelayClearDropEffect", 2.0f);
        Invoke("DelayCreate", 0.2f);
    }
    //延迟生成
    void DelayCreate()
    {
        if (BattleCtrl.instance.levelManager.CurLevelIndex == LevelEnum.levelOneIndex)
        {
            GlobalConfig.LoadFirstRandomFruit(m_SelectNum, m_fruitParent);
        }
        else if (BattleCtrl.instance.levelManager.CurLevelIndex == LevelEnum.levelTwoIndex)
        {
            GlobalConfig.LoadSecondRandomFruit(m_SelectNum, m_fruitParent);
        }
    }
    //refresh
    public void Refresh()
    {
        //Rigidbody[] varBody = m_fruitParent.GetComponentsInChildren<Rigidbody>();
        //for(int i = 0;i<varBody.Length;i++)
        //{
        //    Transform varTrans = varBody[i].transform;
        //    if(varBody[i].transform.localPosition.x < 0)
        //    {
        //        varBody[i].AddForce((Vector3.up + Vector3.right) * 3.0f, ForceMode.Impulse);
        //    }
        //    else
        //    {
        //        varBody[i].AddForce((Vector3.left) * 3.0f, ForceMode.Impulse);
        //    }
        //}
        Transform varStrawberry = PoolManager.Instance.GetObjectRoot(CacheManager.Instance.StrawberryObj);
        if (varStrawberry)
        {
            Rigidbody[] varBody = varStrawberry.GetComponentsInChildren<Rigidbody>();
            for (int i = 0; i < varBody.Length; i++)
            {
                Transform varTrans = varBody[i].transform;
                if (varBody[i].transform.position.x < 0)
                {
                    varBody[i].AddForce((Vector3.up + Vector3.right) * 3.0f, ForceMode.Impulse);
                }
                else
                {
                    varBody[i].AddForce((Vector3.left) * 3.0f, ForceMode.Impulse);
                }
            }
        }
        Transform varLemonberry = PoolManager.Instance.GetObjectRoot(CacheManager.Instance.LemonObj);
        if (varLemonberry)
        {
            Rigidbody[] varBody = varLemonberry.GetComponentsInChildren<Rigidbody>();
            for (int i = 0; i < varBody.Length; i++)
            {
                Transform varTrans = varBody[i].transform;
                if (varBody[i].transform.position.x < 0)
                {
                    varBody[i].AddForce((Vector3.up + Vector3.right) * 3.0f, ForceMode.Impulse);
                }
                else
                {
                    varBody[i].AddForce((Vector3.left) * 3.0f, ForceMode.Impulse);
                }
            }
        }
        Transform varOrangeberry = PoolManager.Instance.GetObjectRoot(CacheManager.Instance.OrangeObj);
        if (varOrangeberry)
        {
            Rigidbody[] varBody = varOrangeberry.GetComponentsInChildren<Rigidbody>();
            for (int i = 0; i < varBody.Length; i++)
            {
                Transform varTrans = varBody[i].transform;
                if (varBody[i].transform.position.x < 0)
                {
                    varBody[i].AddForce((Vector3.up + Vector3.right) * 3.0f, ForceMode.Impulse);
                }
                else
                {
                    varBody[i].AddForce((Vector3.left) * 3.0f, ForceMode.Impulse);
                }
            }
        }
    }
    // Update is called once per frame
    void Update()
    {
        if (!BattleCtrl.instance.isStartBattle || BattleCtrl.instance.isEndBattle)
        {
            return;
        }
        if (Input.GetMouseButton(0))
        {
            Clicked();
        }
        UpdateSelectSize();
    }
    void Clicked()
    {
        Ray ray = Camera.main.ScreenPointToRay(Input.mousePosition);

        RaycastHit hit = new RaycastHit();

        if (Physics.Raycast(ray, out hit,100.0f,2))
        {
            if (hit.collider && hit.collider.gameObject.CompareTag("Target"))
            {
                FruitItemView varHitTrans = hit.collider.transform.GetComponent<FruitItemView>();
                if (!m_selectLst.Contains(varHitTrans))
                {
                    m_bIsTouchUp = false;
                    HighlightableObject varHo = hit.collider.GetComponent<HighlightableObject>();
                    if (varHo)
                    {
                        varHo.FlashingOn(Color.magenta, Color.magenta, 1.0f);
                    }
                    m_curSelectItem = varHitTrans;
                    if(m_selectLst.Count > 0)
                    {
                        m_lastSelectItem = m_selectLst[m_selectLst.Count - 1];
                    }
                    if(m_lastSelectItem)
                    {
                        DrawLS(m_lastSelectItem.transform, m_curSelectItem.transform);
                    }
                    m_selectLst.Add(varHitTrans);
                }
            }
        }
    }
    //选中物体大小变化
    void UpdateSelectSize()
    {
        if (m_curSelectItem)
        {
            if (m_bIsTouchUp)
            {
                m_curSelectItem.SetChangeSmall();
            }
            else
            {
                m_curSelectItem.SetChangeBig();
            }
        }
        if (m_lastSelectItem)
        {
            m_lastSelectItem.SetChangeSmall();
        }
    }
    //线段渲染
    //void ShowLine(Transform trans)
    //{
    //    lineRenderer.positionCount = m_lineIndex + 1;
    //    lineRenderer.SetPosition(m_lineIndex, trans.position);
    //    m_lineIndex++;
    //}

    void DrawLS(Transform startP, Transform finalP)
    {
        Vector3 varStart = startP.position;
        //varStart.z = 0;
        Vector3 varFinal = finalP.position;
        //varFinal.z = 0;
        Vector3 rightPosition = (varStart + varFinal) / 2;
        Vector3 rightRotation = varFinal - varStart;
        float HalfLength = Vector3.Distance(varStart, varFinal) / 2;
        float LThickness = 0.02f;//线的粗细

        //创建圆柱体
        GameObject MyLine = PoolManager.Instance.GetObjectFromPool(CacheManager.Instance.lineObj);
        rightPosition.z = -0.5f;
        MyLine.transform.position = rightPosition;
        MyLine.transform.rotation = Quaternion.FromToRotation(Vector3.up, rightRotation);
        MyLine.transform.localScale = new Vector3(LThickness, HalfLength, LThickness);
        m_lineLst.Add(MyLine);

        //这里可以设置材质，具体自己设置
        //MyLine.GetComponent<MeshRenderer>().material = GetComponent<MeshRenderer>().material;
    }
    //缓存所有水果
    public void CacheAllFruit()
    {
        Transform varStrawberry = PoolManager.Instance.GetObjectRoot(CacheManager.Instance.StrawberryObj);
        if(varStrawberry)
        {
            Rigidbody[] varBody = varStrawberry.GetComponentsInChildren<Rigidbody>();
            for(int i = 0;i<varBody.Length;i++)
            {
                PoolManager.Instance.ReturnObjectToPool(varBody[i].gameObject);
            }
        }
        Transform varLemonberry = PoolManager.Instance.GetObjectRoot(CacheManager.Instance.LemonObj);
        if (varLemonberry)
        {
            Rigidbody[] varBody = varLemonberry.GetComponentsInChildren<Rigidbody>();
            for (int i = 0; i < varBody.Length; i++)
            {
                PoolManager.Instance.ReturnObjectToPool(varBody[i].gameObject);
            }
        }
        Transform varOrangeberry = PoolManager.Instance.GetObjectRoot(CacheManager.Instance.OrangeObj);
        if (varOrangeberry)
        {
            Rigidbody[] varBody = varOrangeberry.GetComponentsInChildren<Rigidbody>();
            for (int i = 0; i < varBody.Length; i++)
            {
                PoolManager.Instance.ReturnObjectToPool(varBody[i].gameObject);
            }
        }
    }
    private void OnDestroy()
    {
        if (GameServices.inputService != null)
        {
            GameServices.inputService.pad.onTouchUp -= OnTouchUp;
        }
        m_lineLst.Clear();
        m_lineLst = null;
        m_selectLst.Clear();
        m_selectLst = null;
        DelayClearEffect();
        DelayClearDropEffect();
        //m_fruitBombEffect.Clear();
        m_fruitBombEffect = null;
        //m_fruitDropEffect.Clear();
        m_fruitDropEffect = null;
    }
}
